<?php
/* --------------------------------------------------------------
  ReadService.php 2020-02-21
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitEan\Service;

use Gambio\Shop\Properties\SellingUnitEan\Repository\Dto\CombiIdDto;
use Gambio\Shop\Properties\SellingUnitEan\Repository\Dto\EanDto;
use Gambio\Shop\Properties\SellingUnitEan\Repository\RepositoryInterface;

/**
 * Class ReadService
 * @package Gambio\Shop\Properties\SellingUnitEan\Service
 */
class ReadService implements ReadServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;
    
    
    public function __construct(RepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getEanValueByPropertyCombination(CombiIdDto $combiIdDto) : EanDto
    {
        return $this->repository->getEanValueByPropertyCombination($combiIdDto);
    }
}